"use client"

import { useState, useEffect } from "react"
import { Card, CardContent, CardHeader, CardTitle } from "@/components/ui/card"
import { Button } from "@/components/ui/button"
import { Label } from "@/components/ui/label"
import { Select, SelectContent, SelectItem, SelectTrigger, SelectValue } from "@/components/ui/select"
import { Slider } from "@/components/ui/slider"
import { Switch } from "@/components/ui/switch"
import { Separator } from "@/components/ui/separator"
import { Badge } from "@/components/ui/badge"
import { ArrowLeft, Settings, Palette, Search, Monitor, Moon, Sun, Save } from "lucide-react"
import { useRouter } from "next/navigation"
import { useTheme } from "@/components/theme-provider"
import { LogoWithText } from "@/components/logo"




import Sidebar from "./Sidebar"

import AppearanceSettings from "./AppearanceSettings"
import SearchPreferences from "./SearchPreferences"
import LanguageRegion from "./LanguageRegion"
import CurrentSettings from "./CurrentSettings"
import YouAndGoogle from "./YouAndGoogle"

export default function SettingsPage() {
  const [active, setActive] = useState("You and Indzs")

  return (
    <div className="flex h-screen bg-background text-gray-200">
      <Sidebar active={active} onChange={setActive} />

      <main className="flex-1 p-8 overflow-y-auto max-w-4xl mx-auto">
        {/* Search bar */}
      <input
        type="text"
        placeholder="Search settings"
        className="w-full mb-6 px-4 py-3 rounded-full bg-[#303134] text-gray-200 placeholder-gray-400 outline-none"
      />
        {renderContent(active)}
      </main>
    </div>
  )
}

function renderContent(active: string) {
  switch (active) {
    case "You and Indzs":
      return <YouAndGoogle />

    case "Appearance":
      return <AppearanceSettings />

    case "Search Preferences":
      return <SearchPreferences />

    case "Language & Region":
      return <LanguageRegion />

    case "Current Settings":
      return (
        <CurrentSettings
          theme="Dark"
          results={50}
          safeSearch={true}
          autoComplete={true}
        />
      )

    default:
      return null
  }
}
